/**
 * Cyber-Assistant - Configuration et constantes
 * Ce fichier contient les constantes partagées par l'application.
 * Il est chargé AVANT bundle.js pour permettre l'extraction progressive.
 */
(function() {
  'use strict';

  // Mapping domaines ISO27002 par préfixe de numéro
  window.DOMAIN_BY_PREFIX = {
    '5': 'Organisationnel',
    '6': 'Humain',
    '7': 'Physique',
    '8': 'Technologique'
  };

  // Normalisation des clés de capacité
  window.normalizeCapabilityKey = function(value) {
    return value
      .normalize('NFD')
      .replace(/[\u0300-\u036f]/g, '')
      .toLowerCase()
      .replace(/[\s'']+/g, "_")
      .replace(/_+/g, "_");
  };

  // Capacités opérationnelles ISO27002
  const CAPABILITY_LABELS = [
    "Gouvernance",
    "Gestion_des_actifs",
    "Protection_des_informations",
    "Sécurité_des_ressources_humaines",
    "Sécurité_physique",
    "Sécurité_système_et_réseau",
    "Sécurité_des_applications",
    "Configuration_sécurisée",
    "Gestion_des_identités_et_des_accès",
    "Gestion_des_menaces_et_des_vulnérabilités",
    "Continuité",
    "Sécurité_des_relations_fournisseurs",
    "Réglementation_et_conformité",
    "Gestion_des_événements_de_sécurité_de_l'information",
    "Assurance_de_sécurité_de_l'information"
  ];

  window.OPERATIONAL_CAPABILITIES = CAPABILITY_LABELS.map(function(label) {
    return {
      key: window.normalizeCapabilityKey(label),
      label: label.replace(/_/g, " ")
    };
  });

  // Catégories NIS2
  window.NIS2_CATEGORIES = [
    'ID.AM', 'ID.BE', 'ID.GV', 'ID.RA', 'ID.RM', 'ID.SC',
    'PR.AC', 'PR.AT', 'PR.DS', 'PR.IP', 'PR.MA', 'PR.PT',
    'DE.AE', 'DE.CM', 'DE.DP',
    'RS.RP', 'RS.CO', 'RS.AN', 'RS.MI', 'RS.IM',
    'RC.RP', 'RC.IM', 'RC.CO'
  ];

  // Configuration des thèmes
  window.THEME_OPTIONS = [
    { value: "light", label: "Clair" },
    { value: "dark", label: "Sombre" },
    { value: "poudre", label: "Poudre" },
    { value: "bleu", label: "Bleu" }
  ];
  window.DEFAULT_THEME = "poudre";
  window.THEME_STORAGE_KEY = "smsi_theme";

  // Statuts des contrôles
  window.CONTROL_STATUS_OPTIONS = [
    { value: "non_implemente", label: "Non implémenté" },
    { value: "en_cours", label: "En cours" },
    { value: "implemente", label: "Implémenté" },
    { value: "verifie", label: "Vérifié" }
  ];

  // Niveaux CMM
  window.CMM_LEVEL_OPTIONS = [
    { value: "Initial", label: "Initial" },
    { value: "Répétable", label: "Répétable" },
    { value: "Défini", label: "Défini" },
    { value: "Géré", label: "Géré" },
    { value: "Optimisé", label: "Optimisé" }
  ];

  // Domaines ISO27002
  window.DOMAIN_OPTIONS = ["Organisationnel", "Humain", "Physique", "Technologique", "Non classé"];

  // Maturité NIS2 par défaut
  window.DEFAULT_NIS2_MATURITY = {
    pilier1: 0,
    pilier2: 0,
    pilier3: 0,
    pilier4: 0,
    pilier5: 0
  };

  // Log de chargement
  if (typeof console !== 'undefined' && console.log) {
    console.log('[CSI] Module constants.js chargé');
  }

})();
