/**
 * English translations for Cyber-Assistant
 * ISMS Management Tool compliant with ISO 27001:2022 / ISO 27002:2022 and NIS2
 */
(function() {
  'use strict';

  const translations = {
    // Application
    app: {
      title: 'Cyber-Assistant',
      subtitle: 'ISO27001 & 27002:2022 Standard',
      loading: 'Loading ISMS application...',
      skipLink: 'Skip to main content'
    },

    // Header buttons
    header: {
      manual: 'User Guide',
      presentation: 'Presentation',
      settings: 'Settings',
      serverSync: 'Server Sync',
      editMode: 'Edit Mode',
      darkMode: 'Dark Mode',
      lightMode: 'Light Mode',
      powderMode: 'Powder Mode'
    },

    // Mode banner
    mode: {
      readOnly: 'Read-only Mode',
      editing: 'Editing Mode',
      editingSubtitle: 'Changes are saved automatically'
    },

    // Navigation
    nav: {
      dashboard: 'Dashboard',
      controlsISO: 'ISO27002 Controls',
      controlsNIS2: 'NIS2 Controls',
      soa: 'Statement of Applicability',
      docReview: '27001 Document Review',
      actions: 'Action Plan',
      risks: 'ISMS Risks',
      threats: 'Threats',
      nonConformities: 'Non-Conformities',
      audits: 'Audits',
      managementReviews: 'Management Reviews',
      stakeholders: 'Stakeholders',
      documents: 'Document Structure',
      kpis: 'KPIs',
      nis2Program: 'NIS2 Program',
      nis2Socle: 'Security Foundation',
      criticalAssets: 'Critical Assets',
      projectRisks: 'Project Risks'
    },

    // Dashboard
    dashboard: {
      title: 'ISMS Dashboard',
      subtitle: 'ISO 27001:2022 Compliance Overview',
      conformityRate: 'Overall Compliance',
      implementedControls: 'Implemented Controls',
      totalActions: 'Actions in Progress',
      criticalRisks: 'Critical Risks',
      openNonConformities: 'Non-Conformities',
      iso27001: 'ISO 27001',
      controls: 'Controls',
      actions: 'Actions',
      risks: 'Risks',
      nc: 'NC'
    },

    // Charts
    charts: {
      iso27002Maturity: 'ISO27002 Maturity',
      nis2Maturity: 'NIS2 Maturity',
      riskDistribution: 'Risk Distribution',
      riskDistributionSubtitle: 'Classification by criticality level: objective evaluation of incidents/actions on a scale (low to critical) to guide resources.',
      controlMaturity: 'Control Maturity',
      controlMaturitySubtitle: 'Distribution by CMM level: mapping of processes across five maturity levels to structure and drive continuous improvement.',
      riskMatrix: 'Risk Matrix',
      riskMatrixSubtitle: 'Impact x Probability: matrix crossing severity and frequency of events to prioritize risks and define mitigation plans.',
      actionsEvolution: 'Actions Evolution',
      actionsEvolutionSubtitle: 'Action plan progression by priority: task prioritization based on urgency and impact, with clear milestones and regular follow-up.',
      noControlNote: 'A value of 0 indicates no associated control.'
    },

    // Controls ISO27002
    controlsISO: {
      title: 'ISO27002 Controls',
      allDomains: 'All domains',
      organizational: 'Organizational',
      human: 'Human',
      physical: 'Physical',
      technological: 'Technological',
      unclassified: 'Unclassified',
      allStatuses: 'All statuses',
      notImplemented: 'Not implemented',
      inProgress: 'In progress',
      implemented: 'Implemented',
      verified: 'Verified',
      allLevels: 'All levels',
      initial: 'Initial',
      repeatable: 'Repeatable',
      defined: 'Defined',
      managed: 'Managed',
      optimized: 'Optimized',
      allCapabilities: 'All capabilities',
      exportExcel: 'Excel Export',
      newControl: 'New Control',
      num: 'Num',
      titleCol: 'Title',
      description: 'Description',
      capability: 'Capability',
      status: 'Status',
      linkedActions: 'Linked Actions',
      cmmLevel: 'CMM Maturity Level'
    },

    // Controls NIS2
    controlsNIS2: {
      title: 'NIS2 Controls',
      allFunctions: 'All functions',
      allCategories: 'All categories',
      function: 'Function',
      category: 'Category',
      justification: 'Justification',
      cmmMaturity: 'CMM Maturity'
    },

    // Statement of Applicability
    soa: {
      title: 'Statement of Applicability',
      all: 'All',
      applicable: 'Applicable',
      notApplicable: 'Not Applicable',
      reference: 'Reference',
      applicability: 'Applicability'
    },

    // Document Review
    docReview: {
      title: '27001 Document Review',
      subtitle: 'Tracking of requirements and associated evidence.',
      requirement: 'Requirement',
      evidence: 'Tool / Evidence'
    },

    // Actions
    actions: {
      title: 'Action Plan',
      sortPriority: 'Sort: Priority',
      sortId: 'Sort: ID',
      sortLink: 'Sort: Linked element',
      sortDueDate: 'Sort: Due date',
      sortProgress: 'Sort: Progress',
      filterAll: 'Filter: All',
      filterRisk: 'Filter: Risk',
      filterNc: 'Filter: Non-conformity',
      filterAudit: 'Filter: Audit',
      filterThreat: 'Filter: Threat',
      filterOwner: 'Filter: Owner',
      filterContinuous: 'Filter: Continuous improvement',
      newAction: 'New Action',
      id: 'ID',
      action: 'Action',
      link: 'Link',
      criticalAssets: 'Critical Assets',
      priority: 'Priority',
      progress: 'Progress',
      dueDate: 'Due Date',
      owner: 'Owner',
      comments: 'Comments'
    },

    // Risks
    risks: {
      title: 'ISMS Risks',
      newRisk: 'New Risk',
      risk: 'Risk',
      impact: 'Impact',
      probability: 'Probability',
      score: 'Score',
      level: 'Level',
      treatment: 'Treatment',
      codirDate: 'CODIR Date'
    },

    // Threats
    threats: {
      title: 'Threats',
      newThreat: 'New Threat'
    },

    // Non-Conformities
    nonConformities: {
      title: 'Non-Conformities',
      sortType: 'Sort: Type',
      sortStatus: 'Sort: Status',
      sortDate: 'Sort: Detection date',
      sortAudit: 'Sort: Linked audit',
      sortOwner: 'Sort: Owner',
      filterAllAudits: 'Filter: All audits',
      filterAllOwners: 'Filter: All owners',
      newNc: 'New Non-Conformity',
      type: 'Type',
      detectionDate: 'Detection Date',
      linkedAudit: 'Linked Audit',
      operations: 'Operations'
    },

    // Audits
    audits: {
      title: 'Audits',
      newAudit: 'New Audit',
      scope: 'Scope',
      plannedDate: 'Planned Date',
      auditor: 'Auditor'
    },

    // Management Reviews
    reviews: {
      title: 'Management Reviews',
      newReview: 'New Review',
      date: 'Date',
      participants: 'Participants',
      inputs: 'Inputs',
      decisions: 'Decisions'
    },

    // Stakeholders
    stakeholders: {
      title: 'Stakeholders',
      newStakeholder: 'New Stakeholder',
      name: 'Name',
      role: 'Role',
      contact: 'Contact'
    },

    // Documents
    documents: {
      title: 'Document Structure',
      newDocument: 'New Document',
      levelCol: 'Level',
      typeCol: 'Type',
      tool: 'Tool',
      linkCol: 'Link'
    },

    // KPIs
    kpis: {
      title: 'KPIs',
      newKpi: 'New KPI',
      comment: 'Comment',
      progressCol: 'Progress'
    },

    // NIS2 Program
    nis2Program: {
      title: 'NIS2 Program',
      printPdf: 'Print / PDF',
      exportHtml: 'Export HTML',
      newDomain: 'New Domain',
      newAction: 'New Action',
      maturity: 'NIS2 Maturity',
      maturitySubtitle: 'Current maturity compared to 2027/2028 targets',
      keyStatuses: 'Key Statuses',
      keyStatusesSubtitle: 'Registration, maturity and regulatory milestones',
      addStatus: 'Add key status',
      nis2Actions: 'NIS2 Actions',
      nis2ActionsSubtitle: 'Distribution of actions by status and overall dynamics',
      actionsByDomain: 'Actions by Domain',
      actionsByDomainSubtitle: 'Distribution of actions by NIS2 plan domain',
      actionPlan: 'NIS2 Action Plan',
      allPhases: 'All phases',
      phase1: 'Phase 1 (2026)',
      phase2: 'Phase 2 (2027)',
      phase3: 'Phase 3 (2028)',
      allPillars: 'All pillars',
      pillar: 'Pillar',
      infoBox: 'This NIS2 action plan is independent from the ISO action plan. Add your domains and actions, filter by phase or pillar, and update statuses to track your 2026-2028 milestones.'
    },

    // NIS2 Socle
    nis2Socle: {
      title: 'Security Foundation',
      subtitle: 'The 5 Structuring Pillars',
      infoBox: 'Prioritized strategic framework based on top 10 major risks, 0trust strategy and NIS2 compliance.'
    },

    // Critical Assets
    criticalAssets: {
      title: 'Critical Assets',
      subtitle: 'Inventory of critical assets and continuity requirements.',
      rename: 'Rename',
      newAsset: 'New Asset',
      beneficiary: 'Beneficiary',
      availability: 'Availability',
      reset: 'Reset',
      priorityCol: 'Priority',
      product: 'Product',
      rto: 'RTO',
      rpo: 'RPO',
      confidentiality: 'Conf.',
      impactCol: 'Impact',
      dacpSensitive: 'Sensitive DACP',
      mfaObligation: 'MFA Obligation'
    },

    // Project Risks
    projectRisks: {
      title: 'Project Risks',
      subtitle: 'Tracking of project risk analyses and associated recommendations.',
      newAnalysis: 'New Analysis',
      search: 'Search',
      searchPlaceholder: 'Name, beneficiary, report, description',
      statusFilter: 'Status',
      pendingFilter: 'Unimplemented recommendations',
      projectName: 'Project Name',
      reportNumber: 'Report Number',
      revisionNumber: 'Revision Number',
      projectDescription: 'Project Description',
      riskAnalysisLink: 'Risk Analysis Link',
      completionDate: 'Completion Date'
    },

    // Settings
    settings: {
      title: 'Settings',
      subtitle: 'Configuration, backups and server synchronization.',
      general: 'General Configuration',
      appTitle: 'Application Title',
      theme: 'Theme',
      themeClair: 'Light',
      themeSombre: 'Dark',
      themePoudre: 'Powder',
      isoTarget: 'ISO Target',
      nis2Target: 'NIS2 Target',
      backup: 'Backup',
      export: 'Export',
      import: 'Import',
      advancedExport: 'Advanced Export',
      pdfReport: 'PDF Report',
      excelExport: 'Excel Export',
      serverSync: 'Server Synchronization',
      baseUrl: 'Base URL',
      user: 'User',
      password: 'Password',
      quality: 'Quality & History',
      analyze: 'Analyze',
      snapshots: 'Snapshots',
      demoData: 'Demo Data',
      loadDemo: 'Load Demo',
      tests: 'Tests',
      runTests: 'Run Tests',
      reset: 'Reset',
      resetData: 'Reset Data',
      language: 'Language',
      chooseLanguage: 'Choose your language'
    },

    // Common
    common: {
      save: 'Save',
      cancel: 'Cancel',
      delete: 'Delete',
      edit: 'Edit',
      add: 'Add',
      close: 'Close',
      search: 'Search',
      filter: 'Filter',
      all: 'All',
      none: 'None',
      yes: 'Yes',
      no: 'No',
      loading: 'Loading...',
      saving: 'Saving...',
      saved: 'Saved',
      error: 'Error',
      success: 'Success',
      warning: 'Warning',
      info: 'Information',
      confirm: 'Confirm',
      confirmDelete: 'Are you sure you want to delete this item? This action is irreversible.',
      noData: 'No data available',
      required: 'This field is required',
      invalid: 'Invalid value',
      exportSuccess: 'Export successful',
      exportError: 'Export failed. Please check that data exists.',
      importSuccess: 'Import successful',
      importError: 'Import failed. Please check the file format.',
      saveError: 'Save failed. Your data is preserved locally.',
      syncSuccess: 'Synchronization successful',
      syncError: 'Synchronization failed'
    },

    // Priorities
    priorities: {
      critical: 'Critical',
      high: 'High',
      medium: 'Medium',
      low: 'Low'
    },

    // Statuses
    statuses: {
      notStarted: 'Not Started',
      inProgress: 'In Progress',
      completed: 'Completed',
      blocked: 'Blocked',
      cancelled: 'Cancelled',
      open: 'Open',
      closed: 'Closed',
      planned: 'Planned',
      realized: 'Realized'
    },

    // Risk levels
    riskLevels: {
      critical: 'Critical',
      high: 'High',
      medium: 'Medium',
      low: 'Low',
      negligible: 'Negligible'
    },

    // Treatment types
    treatments: {
      accept: 'Accept',
      reduce: 'Reduce',
      transfer: 'Transfer',
      avoid: 'Avoid'
    },

    // Months
    months: {
      january: 'January',
      february: 'February',
      march: 'March',
      april: 'April',
      may: 'May',
      june: 'June',
      july: 'July',
      august: 'August',
      september: 'September',
      october: 'October',
      november: 'November',
      december: 'December'
    },

    // First launch
    firstLaunch: {
      title: 'Welcome to Cyber-Assistant',
      subtitle: 'Please select your preferred language',
      continue: 'Continue',
      changeSettings: 'You can change the language at any time in Settings'
    },

    // Footer
    footer: {
      createdBy: 'Designed by Jean-François Avart',
      contactMe: 'Contact me'
    },

    // Search
    search: {
      placeholder: 'Search (actions, risks, controls, documents...)',
      noResults: 'No results found',
      results: 'results'
    },

    // Global search results
    searchResults: {
      action: 'Action',
      risk: 'Risk',
      control: 'Control',
      document: 'Document',
      audit: 'Audit',
      nc: 'Non-Conformity',
      threat: 'Threat',
      stakeholder: 'Stakeholder',
      kpi: 'KPI',
      asset: 'Critical Asset'
    },

    // Server mode
    serverMode: {
      notAvailable: 'Server mode is not available in this version. Contact the publisher to obtain the synchronization module.'
    }
  };

  // Load translations into i18n module
  if (window.CSI_i18n) {
    window.CSI_i18n.loadTranslations('en', translations);
  } else {
    // Store for later loading
    window._pendingTranslations = window._pendingTranslations || {};
    window._pendingTranslations.en = translations;
  }

})();
