/**
 * Dutch translations for Cyber-Assistant
 * ISMS Beheertool conform ISO 27001:2022 / ISO 27002:2022 en NIS2
 */
(function() {
  'use strict';

  const translations = {
    // Application
    app: {
      title: 'Cyber-Assistent',
      subtitle: 'ISO27001 & 27002:2022 Norm',
      loading: 'ISMS-applicatie laden...',
      skipLink: 'Ga naar hoofdinhoud'
    },

    // Header buttons
    header: {
      manual: 'Gebruikshandleiding',
      presentation: 'Presentatie',
      settings: 'Instellingen',
      serverSync: 'Server Sync',
      editMode: 'Bewerkingsmodus',
      darkMode: 'Donkere modus',
      lightMode: 'Lichte modus',
      powderMode: 'Poeder modus'
    },

    // Mode banner
    mode: {
      readOnly: 'Alleen-lezen modus',
      editing: 'Bewerkingsmodus',
      editingSubtitle: 'Wijzigingen worden automatisch opgeslagen'
    },

    // Navigation
    nav: {
      dashboard: 'Dashboard',
      controlsISO: 'ISO27002 Beheersmaatregelen',
      controlsNIS2: 'NIS2 Beheersmaatregelen',
      soa: 'Toepassingsverklaring',
      docReview: '27001 Documentenreview',
      actions: 'Actieplan',
      risks: 'ISMS Risico\'s',
      threats: 'Bedreigingen',
      nonConformities: 'Afwijkingen',
      audits: 'Audits',
      managementReviews: 'Directiebeoordelingen',
      stakeholders: 'Belanghebbenden',
      documents: 'Documentenstructuur',
      kpis: 'KPI\'s',
      nis2Program: 'NIS2 Programma',
      nis2Socle: 'Beveiligingsbasis',
      criticalAssets: 'Kritieke Activa',
      projectRisks: 'Projectrisico\'s'
    },

    // Dashboard
    dashboard: {
      title: 'ISMS Dashboard',
      subtitle: 'Overzicht ISO 27001:2022 Naleving',
      conformityRate: 'Totale Naleving',
      implementedControls: 'Geïmplementeerde Maatregelen',
      totalActions: 'Lopende Acties',
      criticalRisks: 'Kritieke Risico\'s',
      openNonConformities: 'Afwijkingen',
      iso27001: 'ISO 27001',
      controls: 'Maatregelen',
      actions: 'Acties',
      risks: 'Risico\'s',
      nc: 'NC'
    },

    // Charts
    charts: {
      iso27002Maturity: 'ISO27002 Volwassenheid',
      nis2Maturity: 'NIS2 Volwassenheid',
      riskDistribution: 'Risicoverdeling',
      riskDistributionSubtitle: 'Classificatie naar kriticiteitsniveau: objectieve evaluatie van incidenten/acties op een schaal (laag tot kritiek) om middelen te sturen.',
      controlMaturity: 'Beheersmaatregel Volwassenheid',
      controlMaturitySubtitle: 'Verdeling per CMM-niveau: mapping van processen over vijf volwassenheidsniveaus om continue verbetering te structureren en aan te sturen.',
      riskMatrix: 'Risicomatrix',
      riskMatrixSubtitle: 'Impact x Waarschijnlijkheid: matrix die ernst en frequentie van gebeurtenissen kruist om risico\'s te prioriteren en mitigatieplannen te definiëren.',
      actionsEvolution: 'Actie-evolutie',
      actionsEvolutionSubtitle: 'Voortgang actieplan per prioriteit: taakprioritering op basis van urgentie en impact, met duidelijke mijlpalen en regelmatige opvolging.',
      noControlNote: 'Een waarde van 0 geeft aan dat er geen bijbehorende beheersmaatregel is.'
    },

    // Controls ISO27002
    controlsISO: {
      title: 'ISO27002 Beheersmaatregelen',
      allDomains: 'Alle domeinen',
      organizational: 'Organisatorisch',
      human: 'Menselijk',
      physical: 'Fysiek',
      technological: 'Technologisch',
      unclassified: 'Niet geclassificeerd',
      allStatuses: 'Alle statussen',
      notImplemented: 'Niet geïmplementeerd',
      inProgress: 'In uitvoering',
      implemented: 'Geïmplementeerd',
      verified: 'Geverifieerd',
      allLevels: 'Alle niveaus',
      initial: 'Initieel',
      repeatable: 'Herhaalbaar',
      defined: 'Gedefinieerd',
      managed: 'Beheerd',
      optimized: 'Geoptimaliseerd',
      allCapabilities: 'Alle capaciteiten',
      exportExcel: 'Excel Export',
      newControl: 'Nieuwe Maatregel',
      num: 'Nr',
      titleCol: 'Titel',
      description: 'Beschrijving',
      capability: 'Capaciteit',
      status: 'Status',
      linkedActions: 'Gekoppelde Acties',
      cmmLevel: 'CMM Volwassenheidsniveau'
    },

    // Controls NIS2
    controlsNIS2: {
      title: 'NIS2 Beheersmaatregelen',
      allFunctions: 'Alle functies',
      allCategories: 'Alle categorieën',
      function: 'Functie',
      category: 'Categorie',
      justification: 'Motivering',
      cmmMaturity: 'CMM Volwassenheid'
    },

    // Statement of Applicability
    soa: {
      title: 'Toepassingsverklaring',
      all: 'Alle',
      applicable: 'Van toepassing',
      notApplicable: 'Niet van toepassing',
      reference: 'Referentie',
      applicability: 'Toepasselijkheid'
    },

    // Document Review
    docReview: {
      title: '27001 Documentenreview',
      subtitle: 'Opvolging van eisen en bijbehorend bewijsmateriaal.',
      requirement: 'Eis',
      evidence: 'Hulpmiddel / Bewijs'
    },

    // Actions
    actions: {
      title: 'Actieplan',
      sortPriority: 'Sorteren: Prioriteit',
      sortId: 'Sorteren: ID',
      sortLink: 'Sorteren: Gekoppeld element',
      sortDueDate: 'Sorteren: Vervaldatum',
      sortProgress: 'Sorteren: Voortgang',
      filterAll: 'Filter: Alle',
      filterRisk: 'Filter: Risico',
      filterNc: 'Filter: Afwijking',
      filterAudit: 'Filter: Audit',
      filterThreat: 'Filter: Bedreiging',
      filterOwner: 'Filter: Verantwoordelijke',
      filterContinuous: 'Filter: Continue verbetering',
      newAction: 'Nieuwe Actie',
      id: 'ID',
      action: 'Actie',
      link: 'Koppeling',
      criticalAssets: 'Kritieke Activa',
      priority: 'Prioriteit',
      progress: 'Voortgang',
      dueDate: 'Vervaldatum',
      owner: 'Verantwoordelijke',
      comments: 'Opmerkingen'
    },

    // Risks
    risks: {
      title: 'ISMS Risico\'s',
      newRisk: 'Nieuw Risico',
      risk: 'Risico',
      impact: 'Impact',
      probability: 'Waarschijnlijkheid',
      score: 'Score',
      level: 'Niveau',
      treatment: 'Behandeling',
      codirDate: 'CODIR Datum'
    },

    // Threats
    threats: {
      title: 'Bedreigingen',
      newThreat: 'Nieuwe Bedreiging'
    },

    // Non-Conformities
    nonConformities: {
      title: 'Afwijkingen',
      sortType: 'Sorteren: Type',
      sortStatus: 'Sorteren: Status',
      sortDate: 'Sorteren: Detectiedatum',
      sortAudit: 'Sorteren: Gekoppelde audit',
      sortOwner: 'Sorteren: Verantwoordelijke',
      filterAllAudits: 'Filter: Alle audits',
      filterAllOwners: 'Filter: Alle verantwoordelijken',
      newNc: 'Nieuwe Afwijking',
      type: 'Type',
      detectionDate: 'Detectiedatum',
      linkedAudit: 'Gekoppelde Audit',
      operations: 'Operaties'
    },

    // Audits
    audits: {
      title: 'Audits',
      newAudit: 'Nieuwe Audit',
      scope: 'Reikwijdte',
      plannedDate: 'Geplande Datum',
      auditor: 'Auditor'
    },

    // Management Reviews
    reviews: {
      title: 'Directiebeoordelingen',
      newReview: 'Nieuwe Beoordeling',
      date: 'Datum',
      participants: 'Deelnemers',
      inputs: 'Inputs',
      decisions: 'Beslissingen'
    },

    // Stakeholders
    stakeholders: {
      title: 'Belanghebbenden',
      newStakeholder: 'Nieuwe Belanghebbende',
      name: 'Naam',
      role: 'Rol',
      contact: 'Contact'
    },

    // Documents
    documents: {
      title: 'Documentenstructuur',
      newDocument: 'Nieuw Document',
      levelCol: 'Niveau',
      typeCol: 'Type',
      tool: 'Hulpmiddel',
      linkCol: 'Link'
    },

    // KPIs
    kpis: {
      title: 'KPI\'s',
      newKpi: 'Nieuwe KPI',
      comment: 'Opmerking',
      progressCol: 'Voortgang'
    },

    // NIS2 Program
    nis2Program: {
      title: 'NIS2 Programma',
      printPdf: 'Afdrukken / PDF',
      exportHtml: 'HTML Exporteren',
      newDomain: 'Nieuw Domein',
      newAction: 'Nieuwe Actie',
      maturity: 'NIS2 Volwassenheid',
      maturitySubtitle: 'Huidige volwassenheid vergeleken met 2027/2028 doelstellingen',
      keyStatuses: 'Belangrijke Statussen',
      keyStatusesSubtitle: 'Registratie, volwassenheid en wettelijke mijlpalen',
      addStatus: 'Status toevoegen',
      nis2Actions: 'NIS2 Acties',
      nis2ActionsSubtitle: 'Verdeling van acties per status en algemene dynamiek',
      actionsByDomain: 'Acties per Domein',
      actionsByDomainSubtitle: 'Verdeling van acties per NIS2-plandomein',
      actionPlan: 'NIS2 Actieplan',
      allPhases: 'Alle fasen',
      phase1: 'Fase 1 (2026)',
      phase2: 'Fase 2 (2027)',
      phase3: 'Fase 3 (2028)',
      allPillars: 'Alle pijlers',
      pillar: 'Pijler',
      infoBox: 'Dit NIS2-actieplan is onafhankelijk van het ISO-actieplan. Voeg uw domeinen en acties toe, filter op fase of pijler en werk statussen bij om uw 2026-2028 mijlpalen te volgen.'
    },

    // NIS2 Socle
    nis2Socle: {
      title: 'Beveiligingsbasis',
      subtitle: 'De 5 Structurerende Pijlers',
      infoBox: 'Geprioriteerd strategisch kader gebaseerd op de top 10 van belangrijke risico\'s, 0trust-strategie en NIS2-naleving.'
    },

    // Critical Assets
    criticalAssets: {
      title: 'Kritieke Activa',
      subtitle: 'Inventaris van kritieke activa en continuïteitsvereisten.',
      rename: 'Hernoemen',
      newAsset: 'Nieuw Activum',
      beneficiary: 'Begunstigde',
      availability: 'Beschikbaarheid',
      reset: 'Resetten',
      priorityCol: 'Prioriteit',
      product: 'Product',
      rto: 'RTO',
      rpo: 'RPO',
      confidentiality: 'Vertr.',
      impactCol: 'Impact',
      dacpSensitive: 'DACP Gevoelig',
      mfaObligation: 'MFA Verplichting'
    },

    // Project Risks
    projectRisks: {
      title: 'Projectrisico\'s',
      subtitle: 'Opvolging van projectrisicoanalyses en bijbehorende aanbevelingen.',
      newAnalysis: 'Nieuwe Analyse',
      search: 'Zoeken',
      searchPlaceholder: 'Naam, begunstigde, rapport, beschrijving',
      statusFilter: 'Status',
      pendingFilter: 'Niet-geïmplementeerde aanbevelingen',
      projectName: 'Projectnaam',
      reportNumber: 'Rapportnummer',
      revisionNumber: 'Revisienummer',
      projectDescription: 'Projectbeschrijving',
      riskAnalysisLink: 'Risicoanalyse Link',
      completionDate: 'Voltooiingsdatum'
    },

    // Settings
    settings: {
      title: 'Instellingen',
      subtitle: 'Configuratie, back-ups en serversynchronisatie.',
      general: 'Algemene Configuratie',
      appTitle: 'Applicatietitel',
      theme: 'Thema',
      themeClair: 'Licht',
      themeSombre: 'Donker',
      themePoudre: 'Poeder',
      isoTarget: 'ISO Doelstelling',
      nis2Target: 'NIS2 Doelstelling',
      backup: 'Back-up',
      export: 'Exporteren',
      import: 'Importeren',
      advancedExport: 'Geavanceerde Export',
      pdfReport: 'PDF Rapport',
      excelExport: 'Excel Export',
      serverSync: 'Serversynchronisatie',
      baseUrl: 'Basis-URL',
      user: 'Gebruiker',
      password: 'Wachtwoord',
      quality: 'Kwaliteit & Geschiedenis',
      analyze: 'Analyseren',
      snapshots: 'Snapshots',
      demoData: 'Demogegevens',
      loadDemo: 'Demo Laden',
      tests: 'Tests',
      runTests: 'Tests Uitvoeren',
      reset: 'Resetten',
      resetData: 'Gegevens Resetten',
      language: 'Taal',
      chooseLanguage: 'Kies uw taal'
    },

    // Common
    common: {
      save: 'Opslaan',
      cancel: 'Annuleren',
      delete: 'Verwijderen',
      edit: 'Bewerken',
      add: 'Toevoegen',
      close: 'Sluiten',
      search: 'Zoeken',
      filter: 'Filter',
      all: 'Alle',
      none: 'Geen',
      yes: 'Ja',
      no: 'Nee',
      loading: 'Laden...',
      saving: 'Opslaan...',
      saved: 'Opgeslagen',
      error: 'Fout',
      success: 'Succes',
      warning: 'Waarschuwing',
      info: 'Informatie',
      confirm: 'Bevestigen',
      confirmDelete: 'Weet u zeker dat u dit item wilt verwijderen? Deze actie is onomkeerbaar.',
      noData: 'Geen gegevens beschikbaar',
      required: 'Dit veld is verplicht',
      invalid: 'Ongeldige waarde',
      exportSuccess: 'Export geslaagd',
      exportError: 'Export mislukt. Controleer of er gegevens bestaan.',
      importSuccess: 'Import geslaagd',
      importError: 'Import mislukt. Controleer het bestandsformaat.',
      saveError: 'Opslaan mislukt. Uw gegevens worden lokaal bewaard.',
      syncSuccess: 'Synchronisatie geslaagd',
      syncError: 'Synchronisatie mislukt'
    },

    // Priorities
    priorities: {
      critical: 'Kritiek',
      high: 'Hoog',
      medium: 'Gemiddeld',
      low: 'Laag'
    },

    // Statuses
    statuses: {
      notStarted: 'Niet Gestart',
      inProgress: 'In Uitvoering',
      completed: 'Voltooid',
      blocked: 'Geblokkeerd',
      cancelled: 'Geannuleerd',
      open: 'Open',
      closed: 'Gesloten',
      planned: 'Gepland',
      realized: 'Gerealiseerd'
    },

    // Risk levels
    riskLevels: {
      critical: 'Kritiek',
      high: 'Hoog',
      medium: 'Gemiddeld',
      low: 'Laag',
      negligible: 'Verwaarloosbaar'
    },

    // Treatment types
    treatments: {
      accept: 'Accepteren',
      reduce: 'Verminderen',
      transfer: 'Overdragen',
      avoid: 'Vermijden'
    },

    // Months
    months: {
      january: 'Januari',
      february: 'Februari',
      march: 'Maart',
      april: 'April',
      may: 'Mei',
      june: 'Juni',
      july: 'Juli',
      august: 'Augustus',
      september: 'September',
      october: 'Oktober',
      november: 'November',
      december: 'December'
    },

    // First launch
    firstLaunch: {
      title: 'Welkom bij Cyber-Assistent',
      subtitle: 'Selecteer uw voorkeurstaal',
      continue: 'Doorgaan',
      changeSettings: 'U kunt de taal op elk moment wijzigen in Instellingen'
    },

    // Footer
    footer: {
      createdBy: 'Ontworpen door Jean-François Avart',
      contactMe: 'Neem contact met mij op'
    },

    // Search
    search: {
      placeholder: 'Zoeken (acties, risico\'s, maatregelen, documenten...)',
      noResults: 'Geen resultaten gevonden',
      results: 'resultaten'
    },

    // Global search results
    searchResults: {
      action: 'Actie',
      risk: 'Risico',
      control: 'Maatregel',
      document: 'Document',
      audit: 'Audit',
      nc: 'Afwijking',
      threat: 'Bedreiging',
      stakeholder: 'Belanghebbende',
      kpi: 'KPI',
      asset: 'Kritiek Activum'
    },

    // Server mode
    serverMode: {
      notAvailable: 'Servermodus is niet beschikbaar in deze versie. Neem contact op met de uitgever om de synchronisatiemodule te verkrijgen.'
    }
  };

  // Load translations into i18n module
  if (window.CSI_i18n) {
    window.CSI_i18n.loadTranslations('nl', translations);
  } else {
    // Store for later loading
    window._pendingTranslations = window._pendingTranslations || {};
    window._pendingTranslations.nl = translations;
  }

})();
